 ; Ŀ
 ;   Tbone - fillet lines without truncating overlapping ones.             
 ;   Copyright 1995 by Rocket Software                                     
 ;   Having looked at a number of cow's skeletons I am still at a loss     
 ;   to explain where these come from.                                     
 ; 

 ; Ŀ
 ;   Subroutine Spitt: see if a point lies on a line.  Sucks in three      
 ;   arguments, the point and the two endpoints of the line, and returns   
 ;   T if the point is on the line and () otherwise.                       
 ; 
 (DEFUN SPITT (pa linp1 linp2 / ang1 p2 inter1)
 ; Ŀ
 ;   Find the line angle.                                                  
 ; 
  (setq ang1 (angle linp1 linp2))
 ; Ŀ
 ;   Find the endpoint of a theoretical line starting at pa and            
 ;   perpendicular to the line described by the two endpoint arguments.    
 ; 
  (setq p2 (polar pa (+ ang1 (/ pi 2)) 10))
 ; Ŀ
 ;   Now find the intersection of the two.                                 
 ; 
  (setq inter1 (inters linp1 linp2 pa p2))
 ; Ŀ
 ;   If the two intersect and the intersection is at pa, then pa is on     
 ;   the line.                                                             
 ; 
  (if (and inter1 (equal pa inter1 0.0000001)) T ()))
 ; Ŀ
 ;   Spitt end.                                                            
 ; 

 ; Ŀ
 ;   Tbone - the inedible core (unless you're a dog.)                      
 ; 
 (DEFUN C:TBONE ()
  (setvar "cmdecho" 0)
  (setq line1 (entget (car (setq enampt1 (entsel "First line: ")))))
  (setq line2 (entget (car (setq enampt2 (entsel "Second line: ")))))
  (setq lin1a (cdr (assoc 10 line1)))
  (setq lin1b (cdr (assoc 11 line1)))
  (setq lin2a (cdr (assoc 10 line2)))
  (setq lin2b (cdr (assoc 11 line2)))
  (setq pa (inters lin1a lin1b lin2a lin2b ()))
  (command "fillet" enampt1 enampt2)
 ; Ŀ
 ;   The fillet command usually changes the length of the lines involved.  
 ;   If a line has been lenghthened this is ok.  If it has been shortened, 
 ;   that may be ok...                                                     
 ;   So: if the intersection of the two lines lies on either line,         
 ;   restore it to its original length.                                    
 ;   The logic here is a bit obscure, but originally seemed workable.      
 ;   In brief: if a line is lengthened, ok, else restore it.               
 ; 
  (if (spitt pa lin1a lin1b)
      (entmod line1))
  (if (spitt pa lin2a lin2b)
      (entmod line2))
 (princ))